<?php
namespace TotalTheme\Page;

defined( 'ABSPATH' ) || exit;

/**
 * Page Single Blocks.
 *
 * @package TotalTheme
 * @subpackage Page
 * @version 5.4.2
 */
class Single_Blocks {

	/**
	 * Returns the array of page single blocks.
	 */
	public static function choices() {
		$choices = array(
			'title'    => esc_html__( 'Title', 'total' ),
			'media'    => esc_html__( 'Media', 'total' ),
			'content'  => esc_html__( 'Content', 'total' ),
			'share'    => esc_html__( 'Social Share Buttons', 'total' ),
			'comments' => esc_html__( 'Comments', 'total' ),
		);

		/**
		 * Filters the list of single blocks allowed for pages.
		 *
		 * @param array $choices
		 * @param string $instance
		 */
		$choices = (array) apply_filters( 'wpex_page_single_blocks', $choices, 'customizer' );

		return $choices;
	}

	/**
	 * Returns blocks to display.
	 */
	public static function get() {
		$default_blocks = array( 'content' );
		$blocks         = get_theme_mod( 'page_composer', $default_blocks );

		if ( is_string( $blocks ) ) {
			$blocks = $blocks ? explode( ',', $blocks ) : array();
		}

		if ( $blocks ) {

			/*
			 * Make sure only blocks registered to be selected in the customizer can render when
			 * pulled from the theme_mod.
			 */
			$blocks = array_intersect( $blocks, array_keys( self::choices() ) );
		}

		// Set keys equal to values for easier filter removal.
		$blocks = array_combine( $blocks, $blocks );

		// Toolset checks.
		if ( defined( 'TYPES_VERSION' ) && $blocks ) {
			foreach ( $blocks as $block ) {
				if ( ! get_theme_mod( 'cpt_single_block_' . $block . '_enabled', true ) ) {
					unset( $blocks[$block] );
				}
			}
		}

		/**
		 * Filters the single page blocks.
		 *
		 * @param array $blocks
		 * @param string $post_type
		 *
		 * @todo deprecate
		 */
		$blocks = apply_filters( 'wpex_page_single_blocks', $blocks, 'page' );

		/**
		 * Filters the single page blocks.
		 *
		 * @param array $blocks
		 * @param string $post_type
		 */
		$blocks = (array) apply_filters( 'wpex_single_blocks', $blocks, 'page' );

		return $blocks;
	}

	/**
	 * Render Blocks.
	 */
	public static function render() {
		$blocks = self::get();

		if ( empty( $blocks ) || ! is_array( $blocks ) ) {
			return;
		}

		foreach ( $blocks as $block ) {
			if ( 'media' === $block && wpex_has_custom_post_media_position() ) {
				continue;
			}

			if ( 'the_content' !== $block && is_callable( $block ) ) {
				call_user_func( $block );
			} else {
				get_template_part( 'partials/page-single-' . $block );
			}
		}
	}

	/**
	 * Echo class attribute for blocks wrapper element.
	 */
	public static function wrapper_class() {
		$class = array(
			'single-page-article',
			'wpex-clr',
		);

		/**
		 * Filters the single page blocks class.
		 *
		 * @param array $class
		 */
		$class = (array) apply_filters( 'wpex_page_single_blocks_class', $class );

		if ( $class ) {
			echo 'class="' . esc_attr( implode( ' ', $class ) ) . '"';
		}
	}

}