<?php
use TotalTheme\Mobile\Menu as Mobile_Menu;

/**
 * Full Screen mobile menu element that gets populated via JS.
 *
 * @package TotalTheme
 * @subpackage Partials
 * @version 5.4
 */

defined( 'ABSPATH' ) || exit;

$style = get_theme_mod( 'full_screen_mobile_menu_style' ) ?: 'white';

$class = array(
	'full-screen-overlay-nav',
	'wpex-mobile-menu',
	$style,
	// Utility classes
	'wpex-fixed',
	'wpex-w-100',
	'wpex-h-100',
	'wpex-top-0',
	'wpex-left-0',
	'wpex-overflow-y-auto',
	'wpex-font-light',
	'wpex-text-5xl',
	'wpex-leading-normal',
	'wpex-transition-all',
	'wpex-duration-400',
);

switch ( $style ) {
	case 'white':
		$class[] = 'wpex-text-black';
		break;
	case 'black';
		$class[] = 'wpex-text-white';
		break;
}

?>

<div class="<?php echo esc_attr( implode( ' ', $class ) ); ?>" aria-expanded="false" aria-label="<?php echo esc_attr( wpex_get_aria_label( 'mobile_menu' ) ); ?>">
	<button class="full-screen-overlay-nav-close wpex-unstyled-button wpex-antialiased wpex-block wpex-fixed wpex-top-0 wpex-right-0 wpex-text-center wpex-cursor-pointer wpex-font-normal wpex-opacity-30 wpex-hover-opacity-100 wpex-transition-opacity wpex-duration-300">
		<span class="full-screen-overlay-nav-close__icon" aria-hidden="true">×</span>
		<span class="screen-reader-text"><?php echo esc_attr( wpex_get_aria_label( 'mobile_menu_close' ) ); ?></span>
	</button>
	<div class="full-screen-overlay-nav-content wpex-table wpex-w-100 wpex-h-100 wpex-text-center">
		<div class="full-screen-overlay-nav-content-inner wpex-table-cell wpex-align-middle wpex-h-100 wpex-w-100">
			<?php
			/**
			 * Hook: wpex_hook_mobile_menu_top.
			 */
			Mobile_Menu::hook_top(); ?>
			<nav class="full-screen-overlay-nav-menu"><ul></ul></nav>
			<?php
			/**
			 * Displays the mobile menu search form if enabled.
			 */
			Mobile_Menu::search_form( array(
				'class' => 'wpex-max-w-100 wpex-mx-auto wpex-pt-20',
			) ); ?>
			<?php
			/**
			 * Hook: wpex_hook_mobile_menu_bottom.
			 */
			Mobile_Menu::hook_bottom(); ?>
		</div>
	</div>
</div>