<?php
use TotalTheme\Topbar\Core as Topbar;

/**
 * Topbar content.
 *
 * @package TotalTheme
 * @subpackage Partials
 * @version 5.4.5
 */

defined( 'ABSPATH' ) || exit;

$content = Topbar::get_content();

if ( $content || has_nav_menu( 'topbar_menu' ) ) : ?>

	<div id="top-bar-content" <?php Topbar::content_class(); ?>><?php

		// Get topbar menu.
		get_template_part( 'partials/topbar/topbar-menu' );

		// Display content.
		if ( $content ) {
			echo wpex_get_vc_meta_inline_style( Topbar::get_template_id() );
			echo do_shortcode( wp_kses_post( $content ) );
		}

	?></div>

<?php endif; ?>