<?php
namespace TotalThemeCore\Vcex\Blocks\Divider_Dots;

use TotalThemeCore\Vcex\Block as Vcex_Block;

defined( 'ABSPATH' ) || exit;

/**
 * Registers the vcex/divider-dots Block.
 *
 * @package TotalThemeCore
 * @version 1.4
 */
final class Block extends Vcex_Block {

	/**
	 * Block setup.
	 */
	public function setup() {
		$this->block_name = 'divider-dots';
		$this->json_path  = __DIR__;
	}

	/**
	 * Block display.
	 */
	public function render_callback( $atts ) {
		$atts = $this->parse_atts( $atts );
		return $this->do_shortcode( 'vcex_divider_dots', $atts );
	}

	/**
	 * Parse attributes.
	 */
	protected function parse_atts( $atts ) {
		$atts['margin'] = self::parse_margin( $atts['margin'] ?? null );
		return $atts;
	}

	/**
	 * Parse margin.
	 */
	protected function parse_margin( $margin ) {
		if ( $margin ) {
			if ( in_array( $margin, $this->allowed_margins() ) ) {
				switch ( $margin ) {
					case '0px':
						$margin = '0px';
						break;
					default:
						$margin = esc_attr( $margin ) . ' 0';
						break;
				}
			} else {
				$margin = '';
			}
		}
		return $margin;
	}

	/**
	 * Allowed margins.
	 */
	protected function allowed_margins() {
		return array( '0px', '5px', '10px', '15px', '20px', '25px', '30px', '40px', '50px' );
	}

}