<?php
namespace TotalThemeCore\Vcex;

defined( 'ABSPATH' ) || exit;

/**
 * VCEX Shortcodes.
 *
 * The original Visual Composer Extension Plugin by WPExplorer rebuilt for Total.
 *
 * @package TotalThemeCore
 * @version 1.4.3
 */
final class Init {

	/**
	 * Instance.
	 *
	 * @access private
	 * @var object Class object.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Init.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->global_classes();
			static::$instance->include_functions();
			static::$instance->register_shortcodes();
			static::$instance->gutenberg_support();
		}

		return static::$instance;
	}

	/**
	 * Run global classes.
	 */
	public function global_classes() {
		Scripts::instance();
	}

	/**
	 * Include helper functions.
	 */
	public function include_functions() {
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/deprecated.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/core.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/field-description.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/shortcode-atts.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/arrays.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/sanitize.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/grid-filter.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/loadmore.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/entry-classes.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/font-icons.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/onclick.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/scripts.php';
		require_once TTC_PLUGIN_DIR_PATH . 'inc/vcex/functions/parsers.php';
	}

	/**
	 * Register shortcodes.
	 */
	public function register_shortcodes() {
		Shortcodes_Registry::instance()->register_all();
	}

	/**
	 * Gutenberg support for vcex elements.
	 */
	public function gutenberg_support() {
		add_action( 'init', __NAMESPACE__ . '\\Gutenberg::init' );
	}

}