<?php
/**
 * vcex_blog_carousel shortcode output.
 *
 * @package Total Theme Core
 * @subpackage VCEX
 * @version 1.4.5
 */

defined( 'ABSPATH' ) || exit;

$html = '';

// Deprecated Attributes.
if ( ! empty( $atts['term_slug'] ) && empty( $atts['include_categories']) ) {
	$atts['include_categories'] = $atts['term_slug'];
}

// Get shortcode attributes.
$atts = vcex_shortcode_atts( 'vcex_blog_carousel', $atts, 'VCEX_Blog_Carousel_Shortcode' );

// Add before carousel action.
do_action( 'vcex_blog_carousel_before', $atts );

// Define vars.
$atts['post_type'] = 'post';
$atts['taxonomy']  = 'category';
$atts['tax_query'] = '';

// Build the WordPress query.
$vcex_query = vcex_build_wp_query( $atts, 'vcex_blog_carousel' );

// Output posts.
if ( $vcex_query->have_posts() ) :

	// All carousels need a unique classname.
	$unique_classname = vcex_element_unique_classname();

	// Get carousel settings.
	$carousel_settings = vcex_get_carousel_settings( $atts, 'vcex_blog_carousel' );
	$carousel_css = vcex_get_carousel_inline_css( $unique_classname, $carousel_settings );

	if ( $carousel_css ) {
		$html .= $carousel_css;
	}

	// Enqueue scripts.
	vcex_enqueue_carousel_scripts();

	// IMPORTANT: Fallback required from VC update when params are defined as empty.
	$media     = ! empty( $atts['media'] ) ? $atts['media'] : 'true';
	$title     = ! empty( $atts['title'] ) ? $atts['title'] : 'true';
	$date      = ! empty( $atts['date'] ) ? $atts['date'] : 'true';
	$excerpt   = ! empty( $atts['excerpt'] ) ? $atts['excerpt'] : 'true';
	$read_more = ! empty( $atts['read_more'] ) ? $atts['read_more'] : 'false';

	// Sanitize atts.
	$unique_id            = $atts['unique_id'] ?? '';
	$thumbnail_link       = $atts['thumbnail_link'] ?? 'post';
	$style                = $atts['style'] ?? 'default';
	$readmore_style       = $atts['readmore_style'] ?? '';
	$readmore_style_color = $atts['readmore_style_color'] ?? '';
	$arrows_position      = ! empty( $atts['arrows_position'] ) ? $atts['arrows_position'] : 'default';

	// Main Classes.
	$wrap_classes = array(
		'vcex-module',
		'wpex-carousel',
		'wpex-carousel-blog',
		'wpex-clr',
		'owl-carousel',
	);

	if ( $carousel_css ) {
		$wrap_classes[] = 'wpex-carousel--render-onload';
		$wrap_classes[] = $unique_classname;
	}

	if ( ! empty( $atts['bottom_margin'] ) ) {
		$wrap_classes[] = vcex_sanitize_margin_class( $atts['bottom_margin'], 'wpex-mb-' );
	}

	// Lightbox.
	if ( 'lightbox' === $thumbnail_link && 'true' == $media ) {
		vcex_enqueue_lightbox_scripts();
		$lightbox_gallery = $atts['lightbox_gallery'] ?? true;
		$lightbox_gallery = vcex_validate_boolean( $lightbox_gallery );
		if ( $lightbox_gallery ) {
			$wrap_classes[] = 'wpex-carousel-lightbox';
		}
	}

	// Carousel style.
	if ( $style && 'default' !== $style ) {
		$wrap_classes[] = $style;
		if ( 'no-margins' === $style && 'default' === $arrows_position ) {
			$arrows_position = 'abs';
		}
	}

	// Arrow style.
	$arrows_style = ! empty( $atts['arrows_style'] ) ? $atts['arrows_style'] : 'default';
	$wrap_classes[] = 'arrwstyle-' . sanitize_html_class( $arrows_style );

	// Arrow position.
	if ( $arrows_position && 'default' !== $arrows_position ) {
		$wrap_classes[] = 'arrwpos-' . sanitize_html_class( $arrows_position );
	}

	// CSS animation.
	if ( ! empty( $atts['css_animation'] ) ) {
		$wrap_classes[] = vcex_get_css_animation( $atts['css_animation'] );
	}

	// Extra classes.
	if ( ! empty( $atts['classes'] ) ) {
		$wrap_classes[] = vcex_get_extra_class( $atts['classes'] );
	}

	// Visibility.
	if ( ! empty( $atts['visibility'] ) ) {
		$wrap_classes[] = vcex_parse_visibility_class( $atts['visibility'] );
	}

	// Get carousel data settings.
	if ( vcex_vc_is_inline() || '1' == count( $vcex_query->posts ) ) {
		$atts['auto_play'] = false;
	}

	// Convert arrays to strings.
	$wrap_classes = vcex_parse_shortcode_classes( $wrap_classes, 'vcex_blog_carousel', $atts );

	// Wrap Style.
	$wrap_style = vcex_inline_style( array(
		'animation_delay'    => $atts['animation_delay'] ?? '',
		'animation_duration' => $atts['animation_duration'] ?? '',
	) );

	// Display header if enabled.
	if ( ! empty( $atts['header'] ) ) {
		$html .= vcex_get_module_header( array(
			'style'   => $atts['header_style'] ?? '',
			'content' => $atts['header'],
			'classes' => array( 'vcex-module-heading vcex_blog_carousel-heading' ),
		) );
	}

	//*--------------------------------*/
	/* [ Begin Carousel Output ]
	/*--------------------------------*/
	$html .= '<div class="' . esc_attr( $wrap_classes ) . '" data-wpex-carousel="' . $carousel_settings . '"' . vcex_get_unique_id( $unique_id ) . $wrap_style . '>';

		// Start loop.
		$lcount = 0;
		$first_run = true;
		while ( $vcex_query->have_posts() ) :

			// Get post from query.
			$vcex_query->the_post();

			// Post VARS.
			$atts['post_id']             = get_the_ID();
			$atts['post_permalink']      = vcex_get_permalink( $atts['post_id'] );
			$atts['post_title']          = get_the_title();
			$atts['post_esc_title']      = vcex_esc_title( $atts['post_id'] );
			$atts['post_thumbnail']      = get_post_thumbnail_id( $atts['post_id'] );
			$atts['post_thumbnail_link'] = $atts['post_permalink'];

			// Lets store the dynamic $atts['post_id'] into the shortcodes attributes.
			$atts['post_id'] = $atts['post_id'];

			/*--------------------------------*/
			/* [ Begin Entry output ]
			/*--------------------------------*/
			if ( ( 'true' == $media && $atts['post_thumbnail'] )
				|| 'true' == $title
				|| 'true' == $date
				|| 'true' == $excerpt
			) :

				// Entry classes.
				$entry_classes = array(
					'wpex-carousel-slide',
					'wpex-clr'
				);

				// Alignment.
				if ( ! empty( $atts['content_alignment'] ) ) {
					$entry_classes[] = 'text' . sanitize_html_class( $atts['content_alignment'] );
				}

				if ( $atts['post_thumbnail'] ) {
					$entry_classes[] = 'has-media';
				}

				$html .= '<div class="' . esc_attr( implode( ' ', $entry_classes ) ) . '">';

					/*--------------------------------*/
					/* [ Featured Image ]
					/*--------------------------------*/
					if ( 'true' == $media ) {

						$media_html = '';

						if ( $atts['post_thumbnail'] ) {

							$atts['media_type'] = 'thumbnail';

							$media_html .= '<div class="' . esc_attr( implode( ' ', vcex_get_entry_media_class( array( 'wpex-carousel-entry-media' ), 'vcex_blog_carousel', $atts ) ) ) . '">';

								// If thumbnail link doesn't equal none.
								if ( 'none' != $thumbnail_link ) :

									// Link attributes.
									$link_attrs = array(
										'href'  => '',
										'title' => $atts['post_esc_title'],
										'class' => 'wpex-carousel-entry-img',
									);

									// Add lightbox link attributes.
									if ( 'lightbox' == $thumbnail_link ) {

										$lcount++;

										$atts['lightbox_data']  = array(); // must reset for each item
										$lightbox_image_escaped = vcex_get_lightbox_image();
										$atts['lightbox_link']  = $lightbox_image_escaped;

										if ( $lightbox_gallery ) {
											$link_attrs['class'] .= ' wpex-carousel-lightbox-item';
										} else {
											$link_attrs['class'] .= ' wpex-lightbox';
										}

										// Check for video.
										if ( $oembed_video_url = vcex_get_post_video_oembed_url( $atts['post_id'] ) ) {
											$embed_url = vcex_get_video_embed_url( $oembed_video_url );
											if ( $embed_url ) {
												$atts['lightbox_link']               = esc_url( $embed_url );
												$atts['lightbox_data']['data-thumb'] = 'data-thumb="' . $lightbox_image_escaped . '"';
											}
										}

										$link_attrs['data-title']    = $atts['post_esc_title'];
										$link_attrs['data-count']    = intval( $lcount );
										$atts['post_thumbnail_link'] = $atts['lightbox_link'];

									}

									$link_attrs['href'] = esc_url( $atts['post_thumbnail_link'] );

									if ( ! empty( $atts['lightbox_data'] ) ) {
										foreach ( $atts['lightbox_data'] as $ld_k => $ld_v ) {
											$link_attrs[$ld_k] = $ld_v;
										}
									}

								$media_html .= '<a' . vcex_parse_html_attributes( $link_attrs ) . '>';

								endif; // End thumbnail_link check.

								// Thumbnail Args.
								$thumbnail_args = array(
									'attachment'    => $atts['post_thumbnail'],
									'width'         => $atts['img_width'] ?? '',
									'height'        => $atts['img_height'] ?? '',
									'size'          => $atts['img_size'] ?? '',
									'crop'          => $atts['img_crop'] ?? '',
									'attributes'    => array( 'data-no-lazy' => 1 ),
									'class'         => implode( ' ', vcex_get_entry_thumbnail_class( null, 'vcex_blog_carousel', $atts ) ),
									'apply_filters' => 'vcex_blog_carousel_thumbnail_args',
									'filter_arg1'   => $atts,
								);

								// Display post thumbnail.
								$media_html .= vcex_get_post_thumbnail( $thumbnail_args );

								// Inner link overlay.
								$media_html .= vcex_get_entry_image_overlay( 'inside_link', 'vcex_blog_carousel', $atts );

								// Entry after media hook.
								$media_html .= vcex_get_entry_media_after( 'vcex_blog_carousel' );

								// Close link tag.
								if ( 'none' != $thumbnail_link ) {
									$media_html .= '</a>';
								}

								// Outer link overlay.
								$media_html .= vcex_get_entry_image_overlay( 'outside_link', 'vcex_blog_carousel', $atts );

							$media_html .= '</div>';

						}

						$html .= apply_filters( 'vcex_blog_carousel_media', $media_html, $atts );

					} // End media check.

					/*--------------------------------*/
					/* [ Entry Details ]
					/*--------------------------------*/
					if ( 'true' == $title || 'true' == $date || 'true' == $excerpt || 'true' == $read_more ) {

						if ( $first_run ) {

							$content_style = array(
								'opacity'          => $atts['content_opacity'],
								'background_color' => $atts['content_background_color'],
								'border_color'     => $atts['content_border_color'],
							);

							// Old content design settings
							if ( empty( $content_css ) ) {
								if ( isset( $atts['content_background'] ) ) {
									$content_style['background'] = $atts['content_background'];
								}
								if ( isset( $atts['content_padding'] ) ) {
									$content_style['padding'] = $atts['content_padding'];
								}
								if ( isset( $atts['content_margin'] ) ) {
									$content_style['margin'] = $atts['content_margin'];
								}
								if ( isset( $atts['content_border'] ) ) {
									$content_style['border'] = $atts['content_border'];
								}
							}

							$content_style = vcex_inline_style( $content_style );

						}

						$html .= '<div class="' . esc_attr( implode( ' ', vcex_get_entry_details_class( array( 'wpex-carousel-entry-details' ), 'vcex_blog_carousel', $atts ) ) ) . '"' . $content_style . '>';

							/*--------------------------------*/
							/* [ Entry Title ]
							/*--------------------------------*/
							if ( 'true' == $title ) {

								$title_html = '';

								if ( $first_run ) {
									$heading_style = vcex_inline_style( array(
										'margin'         => $atts['content_heading_margin'] ?? '',
										'font_size'      => $atts['content_heading_size'] ?? '',
										'font_weight'    => $atts['content_heading_weight'] ?? '',
										'text_transform' => $atts['content_heading_transform'] ?? '',
										'line_height'    => $atts['content_heading_line_height'] ?? '',
										'color'          => $atts['content_heading_color'] ?? '',
									) );
								}

								$title_html .= '<div class="' . esc_attr( implode( ' ', vcex_get_entry_title_class( array( 'wpex-carousel-entry-title' ), 'vcex_blog_carousel', $atts ) ) ) . '"' . $heading_style . '>';

									$title_html .= '<a href="' . esc_url( $atts['post_permalink'] ) . '">';

										$title_html .= wp_kses_post( $atts['post_title'] );

									$title_html .= '</a>';

								$title_html .= '</div>';

								$html .= apply_filters( 'vcex_blog_carousel_title', $title_html, $atts );

							}

							/*--------------------------------*/
							/* [ Entry Date ]
							/*--------------------------------*/
							if ( 'true' == $date ) {

								$date_html = '';

								if ( $first_run ) {

									$date_style = vcex_inline_style( array(
										'color'     => $atts['date_color'] ?? '',
										'font_size' => $atts['date_font_size'] ?? '',
									) );

								}

								$date_html .= '<div class="' . esc_attr( implode( ' ', vcex_get_entry_date_class( array( 'wpex-carousel-entry-date', 'vcex-blog-entry-date' ), 'vcex_blog_carousel', $atts ) ) ) . '"' . $date_style . '>'; // @todo deprecate vcex-blog-entry-date?

									$date_html .= get_the_date();

								$date_html .= '</div>';

								$html .= apply_filters( 'vcex_blog_carousel_date', $date_html, $atts );

							}

							/*--------------------------------*/
							/* [ Entry Excerpt ]
							/*--------------------------------*/
							if ( 'true' == $excerpt ) {

								$excerpt_html = '';

								if ( $first_run ) {
									$excerpt_styling = vcex_inline_style( array(
										'color'     => $atts['content_color'],
										'font_size' => $atts['content_font_size'],

									) );
								}

								$excerpt_html .= '<div class="' . esc_attr( implode( ' ', vcex_get_entry_excerpt_class( array( 'wpex-carousel-entry-excerpt' ), 'vcex_blog_carousel', $atts ) ) ) . '"' . $excerpt_styling . '>';

									$excerpt_html .= vcex_get_excerpt( array(
										'length'  => $atts['excerpt_length'] ?? '15',
										'context' => 'vcex_blog_carousel',
									) );

								$excerpt_html .= '</div>';

								$html .= apply_filters( 'vcex_blog_carousel_excerpt', $excerpt_html, $atts );

							} // End excerpt check

							/*--------------------------------*/
							/* [ Entry Readmore ]
							/*--------------------------------*/
							if ( isset( $atts['read_more'] ) && vcex_validate_boolean( $atts['read_more'] ) ) {

								$readmore_html = '';

								if ( $first_run ) {

									// Readmore text.
									$read_more_text = ! empty( $atts['read_more_text'] ) ? $atts['read_more_text'] : esc_html__( 'Read more', 'total' );

									// Readmore classes.
									$readmore_classes = vcex_get_button_classes( $readmore_style, $readmore_style_color );

									// Readmore style.
									$readmore_css = vcex_inline_style( array(
										'background'    => $atts['readmore_background'] ?? '',
										'color'         => $atts['readmore_color'] ?? '',
										'font_size'     => $atts['readmore_size'] ?? '',
										'padding'       => $atts['readmore_padding'] ?? '',
										'border_radius' => $atts['readmore_border_radius'] ?? '',
										'margin'        => $atts['readmore_margin'] ?? '',
									), false );

									// Readmore data.
									$readmore_hover_data = array();
									if ( ! empty( $atts['readmore_hover_background'] ) ) {
										$readmore_hover_data['background'] = esc_attr( vcex_parse_color( $atts['readmore_hover_background'] ) );
									}
									if ( ! empty( $atts['readmore_hover_color'] ) ) {
										$readmore_hover_data['color'] = esc_attr( vcex_parse_color( $atts['readmore_hover_color'] ) );
									}
									if ( $readmore_hover_data ) {
										$readmore_hover_data = htmlspecialchars( wp_json_encode( $readmore_hover_data ) );
									}

								}

								$readmore_html .= '<div class="' . esc_attr( implode( ' ', vcex_get_entry_button_wrap_class( array( 'wpex-carousel-entry-button' ), 'vcex_blog_carousel', $atts ) ) ) . '">';

									$readmore_attrs = array(
										'href'  => esc_url( $atts['post_permalink'] ),
										'class' => esc_attr( $readmore_classes ),
										'style' => $readmore_css,
									);

									if ( $readmore_hover_data ) {
										$readmore_attrs['data-wpex-hover'] = $readmore_hover_data;
									}

									$aria_label = sprintf( esc_attr_x( '%s about %s', '*read more text* about *post name* aria label', 'total-theme-core' ), $read_more_text, $atts['post_esc_title'] );

									/**
									 * Filters the more_link aria label.
									 *
									 * @param string $aria_label
									 */
									$aria_label = apply_filters( 'wpex_aria_label', $aria_label, 'more_link' );
									$aria_label = apply_filters( 'vcex_blog_carousel_readmore_aria_label', $aria_label, $atts );

									if ( $aria_label ) {
										$readmore_attrs['aria-label'] = strip_shortcodes( $aria_label );
									}

									$readmore_html .= '<a' . vcex_parse_html_attributes( $readmore_attrs ) . '>';

										$readmore_html .= do_shortcode( wp_kses_post( $read_more_text ) );

										if ( isset( $atts['readmore_rarr'] ) && vcex_validate_boolean( $atts['readmore_rarr'] ) ) {
											$readmore_html .= ' <span class="vcex-readmore-rarr">' . vcex_readmore_button_arrow() . '</span>';
										}

									$readmore_html .= '</a>';

								$readmore_html .= '</div>';

								$html .= apply_filters( 'vcex_blog_carousel_readmore', $readmore_html, $atts );

							}

						$html .= '</div>';

					} // End details check.

				$html .= '</div>';

			endif; // End data check.

		// End entry loop.
		$first_run = false; endwhile;

	$html .= '</div>';

	// Reset the post data to prevent conflicts with WP globals.
	wp_reset_postdata();

	// @codingStandardsIgnoreLine
	echo $html;


// If no posts are found display message.
else :

	// Display no posts found error if function exists.
	echo vcex_no_posts_found_message( $atts );

// End post check.
endif;