<?php
/**
 * vcex_spacing shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.4.5
 */

defined( 'ABSPATH' ) || exit;

// Define vars.
$atts          = vcex_shortcode_atts( 'vcex_spacing', $atts, 'VCEX_Spacing_Shortcode' );
$size          = $atts['size'] ?? null;
$is_responsive = vcex_validate_att_boolean( 'responsive', $atts, false );

// Core class.
$classes = array(
	'vcex-spacing',
	'wpex-w-100',
	'wpex-clear',
);

// Custom Class.
if ( ! empty( $atts['class']  ) ) {
    $classes[] = vcex_get_extra_class( $atts['class'] );
}

// Visiblity Class.
if ( ! empty( $atts['visibility'] ) ) {
    $classes[] = vcex_parse_visibility_class( $atts['visibility'] );
}

// Front-end composer class.
if ( vcex_vc_is_inline() ) {
    $classes[] = 'vc-spacing-shortcode';
}

// Add unique classname.
if ( $is_responsive ) {
	$unique_class = vcex_element_unique_classname();
	$classes[]    = sanitize_html_class( $unique_class );
}

// Generate inline css.
$shortcode_style = '';

if ( $is_responsive ) {
	$inline_css = '<style>';
		$inline_css .= vcex_responsive_attribute_css( $atts['size_responsive'], $unique_class, 'height' );
	$inline_css .= '</style>';
	echo $inline_css;
} elseif ( $size ) {

	// Sanitize size.
	if ( is_numeric( $size ) ) {
		$size = floatval( $size ) . 'px';
	} elseif( 0 === strpos( $size, 'calc' ) || 0 === strpos( $size, 'clamp' ) ) {
		$size = wp_strip_all_tags( $size );
	} elseif( false !== strpos( $size, 'px' ) ) {
		$size = floatval( $size ) . 'px';
	} elseif( false !== strpos( $size, '%' )
		|| false !== strpos( $size, 'em' )
		|| false !== strpos( $size, 'rem' )
		|| false !== strpos( $size, 'vw' )
		|| false !== strpos( $size, 'vh' )
		|| false !== strpos( $size, 'vmin' )
		|| false !== strpos( $size, 'vmax' )
	) {
		$size = wp_strip_all_tags( $size );
	} elseif ( $size = floatval( $size ) ) {
		$size = wp_strip_all_tags( $size ) . 'px';
	}

	$shortcode_style = ' style="height:' . esc_attr( trim( $size ) ) . ';"';

}

// Parse classes.
$classes = vcex_parse_shortcode_classes( $classes, 'vcex_spacing', $atts );

// Echo output.
echo '<div class="' . esc_attr( $classes ) . '"' . $shortcode_style . '></div>';