<?php
namespace TotalThemeCore\WPBakery\Params;

defined( 'ABSPATH' ) || exit;

/**
 * WPBakery Param => Preset textfield.
 *
 * @package TotalThemeCore
 * @version 1.4.3
 */
final class Preset_Textfield {

	public static function output( $settings, $value ) {
		$is_preset = false;
		$choices   = array();

		switch ( $settings['choices'] ) {
			case 'border_radius':
				if ( function_exists( 'vcex_border_radius_choices' ) ) {
					$choices = (array) vcex_border_radius_choices( $settings['supports_blobs'] ?? false );
				}
				break;
			case 'margin':
				if ( function_exists( 'vcex_margin_choices' ) ) {
					$choices = (array) vcex_margin_choices();
				}
				break;
			case 'letter_spacing':
				if ( function_exists( 'vcex_letter_spacing_choices' ) ) {
					$choices = (array) vcex_letter_spacing_choices();
				}
				break;
			case 'font_size':
				if ( function_exists( 'vcex_font_size_choices' ) ) {
					$choices = (array) vcex_font_size_choices();
				}
				break;
			case 'line_height':
				if ( function_exists( 'vcex_line_height_choices' ) ) {
					$choices = (array) vcex_line_height_choices();
				}
				break;
			case 'opacity':
				if ( function_exists( 'vcex_opacity_choices' ) ) {
					$choices = (array) vcex_opacity_choices();
				}
				break;
			case 'icon_size':
				if ( function_exists( 'vcex_icon_size_choices' ) ) {
					$choices = (array) vcex_icon_size_choices();
				}
				break;
			case 'gap':
				if ( function_exists( 'wpex_column_gaps' ) ) {
					$gap_choices = wpex_column_gaps();
					$choices = array_flip( $gap_choices );
					if ( '0px' === $value ) {
						$value = 'none';
					} elseif ( in_array( $value, $gap_choices ) ) {
						$value = absint( $value );
					}
				}
				break;
			default:
				if ( is_array( $settings['choices'] ) ) {
					$choices = $settings['choices'];
				}
				break;
		}

		if ( ! $is_preset && ( ! $value || in_array( $value, $choices ) ) ) {
			$is_preset = true;
		}

		$html = '<div class="vcex-param-preset-textfield">';

			if ( $choices ) {
				$html .= '<div class="vcex-param-preset-textfield__fields">';
					$hidden = $is_preset ? '' : ' style="display: none;"';
					$html .= '<div class="vcex-param-preset-textfield__preset"' . $hidden . '>';
						$html .= self::choices( $value, $choices );
					$html .= '</div>';
					$hidden = $is_preset ? ' style="display: none;"' : '';
					$html .= '<div class="vcex-param-preset-textfield__custom"' . $hidden . '>';
						$html .= self::custom_input( $is_preset, $value, $settings );
					$html .= '</div>';
				$html .= '</div>';
				$html .= self::toggle_button( $is_preset, $value );
			}

			// This is needed or else nothing gets saved.
			$html .= '<input name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value  ' . esc_attr( $settings['param_name'] ) . ' ' . esc_attr( $settings['type'] ) . '_field" type="hidden" value="' . esc_attr( $value ) . '">';

		$html .= '</div>';

		if ( empty( $settings['description'] ) ) {
			$desc = vcex_shortcode_param_description( $settings['choices'] );
			if ( $desc ) {
				$html .= '<div class="vc_description vc_clearfix">' . esc_html( $desc ) . '</div>';
			}
		}

		return $html;
	}

	protected static function choices( $value, $choices ) {
		$html = '';
		$html .= '<select class="vcex-param-preset-textfield__select wpb-select">';
			foreach ( $choices as $choice_name => $choice_k ) {
				$html .= '<option value="' . esc_attr( $choice_k ) . '" ' . selected( $value, $choice_k, false ) . '>' . esc_html( $choice_name ) . '</option>';
			}
		$html .= '</select>';
		return $html;
	}

	protected static function toggle_button( $is_preset, $value ) {
		$toggle_pressed = ( ! $is_preset && $value ) ? 'true' : 'false';
		return '<button class="vcex-param-preset-textfield__toggle" aria-pressed="' . $toggle_pressed . '" aria-label="' . esc_attr( 'Toggle between preset options and custom inputs.', 'total-theme-core' ) . '"><svg width="18" height="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" role="img" aria-hidden="true" focusable="false" fill="currentColor"><path d="M14.5 13.8c-1.1 0-2.1.7-2.4 1.8H4V17h8.1c.3 1 1.3 1.8 2.4 1.8s2.1-.7 2.4-1.8H20v-1.5h-3.1c-.3-1-1.3-1.7-2.4-1.7zM11.9 7c-.3-1-1.3-1.8-2.4-1.8S7.4 6 7.1 7H4v1.5h3.1c.3 1 1.3 1.8 2.4 1.8s2.1-.7 2.4-1.8H20V7h-8.1z"></path></svg></button>';
	}

	protected static function custom_input( $is_preset, $value, $settings ) {
		$html = '';
		$custom_val  = ! $is_preset ? $value : '';
		$placeholder = isset( $settings['placeholder'] ) ? 'placeholder="' . esc_attr( $settings['placeholder'] ) . '"' : '';
		$responsive = $settings['responsive_input'] ?? false;
		if ( $responsive ) {
			return self::responsive_input( $custom_val, $settings );
		} else {
			return '<input class="vcex-param-preset-textfield__input wpb-textinput" type="text" value="' . esc_attr( $custom_val ) . '"' . $placeholder . '>';
		}
	}

	protected static function responsive_input( $value, $settings ) {
		$html = '';

		if ( $value && false === strpos( $value, ':' ) ) {
			$ogvalue = $value;
			$value = 'd:' . $value;
		}

		$medias = array(
			'd'  => array(
				'label' => esc_html__( 'Desktop', 'total-theme-core' ),
				'icon'  => 'dashicons dashicons-desktop',
			),
			'tl' => array(
				'label' => esc_html__( 'Tablet Landscape', 'total-theme-core' ),
				'icon'  => 'dashicons dashicons-tablet',
			),
			'tp' => array(
				'label' => esc_html__( 'Tablet Portrait', 'total-theme-core' ),
				'icon'  => 'dashicons dashicons-tablet',
			),
			'pl' => array(
				'label' => esc_html__( 'Phone Landscape', 'total-theme-core' ),
				'icon'  => 'dashicons dashicons-smartphone',
			),
			'pp' => array(
				'label' => esc_html__( 'Phone Portrait', 'total-theme-core' ),
				'icon'  => 'dashicons dashicons-smartphone',
			),
		);

		foreach ( $medias as $key => $val ) {
			$defaults[$key] = '';
		}

		if ( function_exists( 'vcex_parse_multi_attribute' ) ) {
			$field_values = vcex_parse_multi_attribute( $value, $defaults );
		} else {
			$field_values = array();
			$params_pairs = explode( '|', $value );
			if ( ! empty( $params_pairs ) ) {
				foreach ( $params_pairs as $pair ) {
					$param = preg_split( '/\:/', $pair );
					if ( ! empty( $param[0] ) && isset( $param[1] ) ) {
						if ( 'http' == $param[1] && isset( $param[2] ) ) {
							$param[1] = rawurlencode( 'http:' . $param[2] ); // fix for incorrect urls that are not encoded
						}
						$field_values[ $param[0] ] = rawurldecode( $param[1] );
					}
				}
			}
		}

		$html .= '<div class="vcex-param-responsive-fields">';

			$count = 0;
			foreach ( $medias as $key => $val ) {
				$count++;

				$field_name = $settings['param_name'] . '[' . $key . ']';
				$icon_class = $val['icon'];

				$html .= '<div class="vcex-param-responsive-fields__item">';

					if ( 'pl' === $key || 'tl' === $key ) {
						$icon_class .= ' dashicons--flip';
					}

					$html .= '<div class="vcex-param-responsive-fields__icon"><span class="' . esc_attr( $icon_class ) . '"></span></div>';

					$html .= '<label for="' . esc_attr( $field_name ) .'" class="screen-reader-text">' . $medias[$key]['label'] . '</label>';

					$html .= '<input id="' . esc_attr( $field_name ) .'" data-vcex-device="' . esc_attr( $key ) . '" value="' . esc_attr( $field_values[$key] ) . '" type="text" placeholder="-">';

				$html .= '</div>';

			}

		$html .= '</div>';

		if ( ! empty( $ogvalue ) ) {
			$value = $ogvalue;
		}

		$html .= '<input class="vcex-param-preset-textfield__input" value="' . esc_attr( $value ) . '" type="hidden">';

		return $html;

	}

}