if ( 'function' !== typeof window.wpexWcCartOverlay ) {
	window.wpexWcCartOverlay = function() {
		var cartOverlay = document.querySelector( '#wpex-cart-overlay' );

		if ( ! cartOverlay ) {
			return;
		}

		var toggleBtn = null;
		var isOpen    = false;
		var targets   = 'a.toggle-cart-widget, li.toggle-cart-widget > a, li.toggle-header-cart > a, .wpex-header-cart-icon button';

		var show = function() {
			cartOverlay.classList.add( 'active' );

			document.querySelectorAll( targets ).forEach( function( element ) {
				element.classList.add( 'active' );
				element.setAttribute( 'aria-expanded', 'true' );
			} );

			if ( 'function' === typeof jQuery ) {
				jQuery( document ).trigger( 'show.wpex.menuCart' );
			}

			var focus = function( event ) {
				if ( 'object' === typeof wpex && 'function' === typeof wpex.focusOnElement ) {
					wpex.focusOnElement( cartOverlay );
				}
				cartOverlay.removeEventListener( 'transitionend', focus ); // remove event as it keeps triggering.
			};

			// Focus on the search when opening after transition is complete to prevent issues.
			cartOverlay.addEventListener( 'transitionend', focus );

			isOpen = true;

		};

		var hide = function() {
			cartOverlay.classList.remove( 'active' );
			document.querySelectorAll( targets ).forEach( function( element ) {
				element.classList.remove( 'active' );
				element.setAttribute( 'aria-expanded', 'false' );
			} );
			if ( toggleBtn ) {
				toggleBtn.focus();
			}
			isOpen = false;
		};

		document.addEventListener( 'click', function( event ) {
			var target = event.target.closest( targets );
			if ( ! target ) {
				if ( ! event.target.closest( '#wpex-cart-overlay .wpex-inner' ) && isOpen ) {
					hide();
				}
				return;
			}
			toggleBtn = target;
			if ( toggleBtn.classList.contains( 'go-to-shop' ) ) {
				return;
			}
			event.preventDefault();
			if ( isOpen ) {
				hide();
			} else {
				show();
			}
		} );

		document.addEventListener( 'keydown', function( event ) {
			var code = event.keyCode || event.which;
			if ( 27 === code && isOpen ) {
				hide();
			}
		} );
	};
}

if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
	setTimeout( wpexWcCartOverlay, 0 );
} else {
	document.addEventListener( 'DOMContentLoaded', wpexWcCartOverlay, false );
}