( function( $ ) {

	'use strict';

	var modelId, context;

	/**
	 * Always reload.
	 */
	var globalReloads = function() {
		if ( 'function' === typeof window.wpexSliderPro ) {
			wpexSliderPro();
		}

		if ( 'function' === typeof window.wpexIsotope ) {
			wpexIsotope();
		}

		if ( 'object' === typeof wpex ) {

			if ( 'function' === typeof wpex.equalHeights ) {
				wpex.equalHeights();
			}

			if ( 'function' === typeof wpex.hoverStyles ) {
				wpex.hoverStyles();
			}

			if ( 'function' === typeof wpex.parallax ) {
				wpex.parallax();
			}

			if ( 'function' === typeof wpex.customSelects ) {
				wpex.customSelects();
			}

			if ( 'function' === typeof wpex.menuWidgetAccordion ) {
				wpex.menuWidgetAccordion();
			}

		}
	};

	/**
	 * Remove duplicates.
	 */
	var removeDups = function() {
		if ( modelId ) {
			context = document.querySelector( '[data-model-id="' + modelId + '"]' );
		}

		if ( ! context ) {
			return;
		}

		let $this = $( context );
		let $module = $this.children( ':first' );

		if ( ! $module.length ) {
			return;
		}

		// Overlay header offset.
		let $overlayHeaderOffsetDiv = $module.find( '> .overlay-header-offset-div' );
		if ( $overlayHeaderOffsetDiv.length ) {
			if ( $module.hasClass( 'add-overlay-header-offset' ) ) {
				$overlayHeaderOffsetDiv.not( ':first' ).remove();
				if ( 'object' === typeof wpex && 'function' === typeof wpex.headerOverlayOffset ) {
					wpex.headerOverlayOffset();
				}
			} else {
				$overlayHeaderOffsetDiv.remove();
			}
		}

		// Shape dividers.
		let $topShapeDivider = $module.find( '> .wpex-shape-divider-top' );
		if ( $topShapeDivider.length ) {
			if ( $module.hasClass( 'wpex-has-shape-divider-top' ) ) {
				$topShapeDivider.not( ':first' ).remove();
			} else {
				$topShapeDivider.remove();
			}
		}

		let $bottomShapeDivider = $module.find( '> .wpex-shape-divider-bottom' );
		if ( $bottomShapeDivider.length ) {
			if ( $module.hasClass( 'wpex-has-shape-divider-bottom' ) ) {
				$bottomShapeDivider.not( ':first' ).remove();
			} else {
				$bottomShapeDivider.remove();
			}
		}

		// Overlays.
		let $overlays = $module.find( '> .wpex-bg-overlay-wrap' );
		if ( $overlays.length ) {
			if ( $module.hasClass( 'wpex-has-overlay' ) ) {
				$overlays.not( ':first' ).remove();
			} else {
				$overlays.remove();
			}
		}

		// Self-hosted Videos.
		let $videos = $module.find( '> .wpex-video-bg-wrap' );
		if ( $videos.length ) {
			if ( $module.hasClass( 'wpex-has-video-bg' ) ) {
				$videos.not( ':first' ).remove();
			} else {
				$videos.remove();
			}
		}

		// Parallax.
		let $parallax = $module.find( '> .wpex-parallax-bg' );
		if ( $parallax.length ) {
			if ( $module.hasClass( 'wpex-parallax-bg-wrap' ) ) {
				$parallax.not( ':first' ).remove();
			} else {
				$parallax.remove();
			}
		}

		// Video Backgrounds - Deprecated? @todo Remove & test.
		let $videoOverlays = $module.find( '> .wpex-video-bg-overlay' );
		if ( $videoOverlays.length ) {
			$videoOverlays.not( ':first' ).remove();
		}
	};

	parent.vc.events.on( 'shortcodes:add shortcodes:update shortcodes:clone', function( model ) {
		modelId = model.id;
	} );

	// Must use jQuery since we can't check for events registered with jQuery using javascript.
	$( window ).on( 'vc_reload', function() {
		globalReloads();
		removeDups();
	} );

} ) ( jQuery );