window.vc_waypoints = function () {
	if ( 'undefined' !== typeof (jQuery.fn.vcwaypoint) ) {
		// Standard VC animations.
		jQuery( '.wpb_animate_when_almost_visible:not(.wpb_start_animation)' ).each( function() {
			const $el = jQuery( this );
			if ( $el.closest( '.wpb-animate-in-sequence' ).length ) {
				return;
			}
			$el.vcwaypoint( function () {
				$el.addClass( 'wpb_start_animation animated' );
			}, { offset: wpex_vc_waypoints_params.offset } );
		} );
		// Staggered animations.
		jQuery( '.wpb-animate-in-sequence .wpb_animate_when_almost_visible:not(.wpb_start_animation)' ).each( function() {
			const $el = jQuery( this );
			const $parent = $el.closest( '.wpb-animate-in-sequence' );
			let delay = $parent.attr( 'data-animation-delay' ) || wpex_vc_waypoints_params.delay;
			const waypoint = new VcWaypoint( {
				element: $el,
				offset: wpex_vc_waypoints_params.offset,
				handler: function( direction ) {
				//	console.log( direction );
					$el.addClass( 'wpb_animation_queue_item' );
					jQuery( '.wpb_animation_queue_item' ).each( function( index ) {
						const $this = jQuery( this );
						setTimeout( function() {
							$this.addClass( 'wpb_start_animation animated' );
							$this.removeClass( 'wpb_animation_queue_item' );
						}, delay * index );
					} );
				}
			} );
		} );
	}
};

jQuery( document ).ready( function ( $ ) {
	if ( 'undefined' === typeof window.vc_js ) {
		window.setTimeout( vc_waypoints, 500 );
	}
} );