<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_search'] = array(
	'title'  => esc_html__( 'Search Results Page', 'total' ),
	'panel'  => 'wpex_general',
	'settings' => array(
		array(
			'id' => 'search_has_page_header',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Page Header Title', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_has_page_header',
			),
		),
		array(
			'id' => 'search_custom_sidebar',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Custom Sidebar', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'search_standard_posts_only',
			'control' => array(
				'label' => esc_html__( 'Standard Posts Only', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'search_results_cpt_loops',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Post Type Query Var', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'When enabled, using ?post_type={post_type_name} in the search URL will return that post type archive design as opposed to the general search archive design.', 'total' ),
			),
			'control_display' => array(
				'check' => 'search_archive_template_id',
				'value' => 'false',
			),
		),
		array(
			'id' => 'search_posts_per_page',
			'default' => '10',
			'control' => array(
				'label' => esc_html__( 'Posts Per Page', 'total' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'search_layout',
			'control' => array(
				'label' => esc_html__( 'Layout', 'total' ),
				'type' => 'select',
				'choices' => 'post_layout',
			),
		),
		array(
			'id' => 'search_archive_template_id',
			'control' => array(
				'label' => esc_html__( 'Dynamic Template', 'total' ),
				'type' => 'wpex-dropdown-templates',
				'description' => esc_html__( 'Select a template to override the default output for your search results.', 'total' ),
			),
		),
		array(
			'id' => 'search_style',
			'default' => 'default',
			'control' => array(
				'label' => esc_html__( 'Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'default' => esc_html__( 'Left Thumbnail', 'total' ),
					'blog' => esc_html__( 'Inherit From Blog','total' ),
				),
				'active_callback' => 'wpex_cac_hasnt_search_card',
			),
		),
		array(
			'id' => 'search_entry_card_style',
			'control' => array(
				'label' => esc_html__( 'Card Style', 'total' ),
				'type' => 'wpex-card-select',
			),
			'control_display' => array(
				'check' => 'search_archive_template_id',
				'value' => 'false',
			),
		),
		array(
			'id' => 'search_archive_grid_style',
			'default' => 'fit-rows',
			'control' => array(
				'label' => esc_html__( 'Grid Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'fit-rows' => esc_html__( 'Fit Rows','total' ),
					'masonry' => esc_html__( 'Masonry','total' ),
				),
				'active_callback' => 'wpex_cac_has_search_card',
			),
		),
		array(
			'id' => 'search_entry_columns',
			'default' => '2',
			'control' => array(
				'label' => esc_html__( 'Columns', 'total' ),
				'type' => 'wpex-columns',
				'active_callback' => 'wpex_cac_has_search_card',
			),
		),
		array(
			'id' => 'search_archive_grid_gap',
			'control' => array(
				'label' => esc_html__( 'Gap', 'total' ),
				'type' => 'select',
				'choices' => 'column_gap',
				'active_callback' => 'wpex_cac_has_search_card',
			),
		),
		array(
			'id' => 'search_entry_excerpt_length',
			'default' => '30',
			'control' => array(
				'label' => esc_html__( 'Excerpt length', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Enter 0 or leave blank to disable, enter -1 to display the full post content.', 'total' ),
			),
			'control_display' => array(
				'check' => 'search_archive_template_id',
				'value' => 'false',
			),
		),
	),
);