<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_header_menu_dropdowns'] = array(
	'title' => esc_html__( 'Menu Dropdowns', 'total' ),
	'panel' => 'wpex_header',
	'settings' => array(
		array(
			'id' => 'menu_arrow_down',
			'control' => array(
				'label' => esc_html__( 'Top Level Dropdown Arrows', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'menu_arrow_side',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Sub Dropdown Arrows', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'menu_dropdown_caret',
			'default' => true,
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Dropdown Pointer', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_menu_supports_pointer',
			),
		),
		array(
			'id' => 'menu_dropdown_top_border',
			'control' => array(
				'label' => esc_html__( 'Colored Top Border', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'menu_drodown_animate',
			'control' => array(
				'label' => esc_html__( 'Dropdown Animation', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'menu_drodown_animate_offset',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Dropdown Animation Offset', 'total' ),
				'type' => 'wpex_pixel',
				'input_attrs' => array(
					'placeholder' => '10',
				),
			),
			'control_display' => array(
				'check' => 'menu_drodown_animate',
				'value' => 'true',
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => array( '--wpex-dropmenu-animate-offset', '--wpex-sf-menu-animate-offset' ),
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'menu_dropdown_method',
			'default' => 'sfhover',
			'control' => array(
				'label' => esc_html__( 'Dropdown Method', 'total' ),
				'type' => 'select',
				'choices' => array(
					'sfhover' => esc_html__( 'Superfish JS', 'total' ),
					'hover' => esc_html__( 'CSS Hover', 'total' ),
					'click' => esc_html__( 'On Click', 'total' ),
				),
			),
		),
		array(
			'id' => 'menu_arrow',
			'control' => array(
				'label' => esc_html__( 'Dropdown Arrow Type', 'total' ),
				'type' => 'select',
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'angle' => esc_html__( 'Angle', 'total' ),
					'angle-double' => esc_html__( 'Angle Double', 'total' ),
					'chevron' => esc_html__( 'Chevron', 'total' ),
					'caret' => esc_html__( 'Caret', 'total' ),
					'arrow' => esc_html__( 'Arrow', 'total' ),
					'arrow-circle' => esc_html__( 'Arrow Circle', 'total' ),
					'plus' => esc_html__( 'Plus', 'total' ),
					// @todo add some svg options.
				),
			),
		),
		array(
			'id' => 'menu_dropdown_style',
			'default' => 'default',
			'control' => array(
				'label' => esc_html__( 'Dropdown Style', 'total' ),
				'type' => 'select',
				'choices' => wpex_get_menu_dropdown_styles(),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'menu_dropdown_dropshadow',
			'transport' => 'postMessage',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Dropdown Dropshadow Style', 'total' ),
				'type' => 'select',
				// @todo support utility shadows?
				'choices' => array(
					'' => esc_html__( 'None', 'total' ),
					'one' => esc_html__( 'One', 'total' ),
					'two' => esc_html__( 'Two', 'total' ),
					'three' => esc_html__( 'Three', 'total' ),
					'four' => esc_html__( 'Four', 'total' ),
					'five' => esc_html__( 'Five', 'total' ),
					'six' => esc_html__( 'Six', 'total' ),
				),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'dropdown_menu_min_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Minimum Width', 'total' ),
				'placeholder' => '140',
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-dropmenu-width',
				'sanitize' => 'px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'dropdown_menu_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'exclude_units' => array( '%' ),
				'label' => esc_html__( 'Dropdown Padding', 'total' ),
				'description' => esc_html__( 'This padding gets added inside the dropdown around all the menu items.', 'total' ),
				'placeholder' => '0',
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => array(
					'--wpex-dropmenu-padding',
					'--wpex-megamenu-padding',
				),
				'sanitize' => 'fallback_px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'dropdown_menu_link_padding_y',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'exclude_units' => array( '%' ),
				'label' => esc_html__( 'Link Vertical Padding', 'total' ),
				'placeholder' => '8',
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-dropmenu-link-padding-y',
				'sanitize' => 'fallback_px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'dropdown_menu_link_padding_x',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'exclude_units' => array( '%' ),
				'label' => esc_html__( 'Link Horizontal Padding', 'total' ),
				'placeholder' => '12',
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-dropmenu-link-padding-x',
				'sanitize' => 'fallback_px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'dropdown_menu_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => array(
					'--wpex-dropmenu-bg',
					'--wpex-dropmenu-caret-bg',
				),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		// Borders
		array(
			'id' => 'dropdown_menu_borders',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Border Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => array(
					'--wpex-dropmenu-border-color',
					'--wpex-dropmenu-caret-border-color',
					'--wpex-megamenu-divider-color',
				),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'menu_dropdown_top_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Colored Top Border', 'total' ),
				'active_callback' => 'wpex_cac_has_menu_dropdown_top_border', // not working with control_display
			),
			'inline_css' => array(
				'target' => ':root', // must target root since some items are outside of the menu.
				'alter' => '--wpex-dropmenu-colored-top-border-color',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		// Link color
		array(
			'id' => 'dropdown_menu_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-dropmenu-link-color',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'dropdown_menu_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-hover-dropmenu-link-color',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'dropdown_menu_link_hover_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Background: Hover', 'total' ),
			),
			'subtitle' => esc_html__( 'Select your custom hex color.', 'total' ),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-hover-dropmenu-link-bg',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'dropdown_menu_link_color_active',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Current Menu Item', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => array(
					'--wpex-active-dropmenu-link-color',
					'--wpex-active-hover-dropmenu-link-color',
				),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'dropdown_menu_link_bg_active',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Background: Current Menu Item', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => array(
					'--wpex-active-dropmenu-link-bg',
					'--wpex-active-hover-dropmenu-link-bg',
				),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
	),
);