<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_header_logo'] = array(
	'title' => esc_html__( 'Logo', 'total' ),
	'panel' => 'wpex_header',
	'settings' => array(
		array(
			'id' => 'logo_text',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Logo Text', 'total' ),
				'input_attrs' => array(
					'placeholder' => esc_html( get_bloginfo( 'name' ) ),
				),
				'description' => esc_html__( 'By default the theme uses your "Site Title" for the logo text but you can enter a custom text here to override it. This will also be used for the logo alt tag when displaying an image based logo.', 'total' ),
			),
		),
		array(
			'id' => 'logo_top_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Top Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => '.logo-padding',
				'alter' => 'padding-top',
				'sanitize' => 'fallback_px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten', 'six' ),
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'logo_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Bottom Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => '.logo-padding',
				'alter' => 'padding-bottom',
				'sanitize' => 'fallback_px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten', 'six' ),
				'compare' => 'not_equal',
			),
		),
		// @todo update to use css var? (like a mobile menu gutter).
		array(
			'id' => 'logo_mobile_side_offset',
			'transport' => 'refresh', // this is an advanced CSS option because of RTL and custom mobile menu breakpoint.
			'control' => array(
				'type' => 'wpex_pixel',
				'label' => esc_html__( 'Mobile Side Offset', 'total' ),
				'description' => esc_html__( 'You can use this option to add an offset to your logo on the right side (or left for RTL layouts) if needed to prevent any content from overlapping your logo such as your mobile menu toggle when using a larger sized logo.', 'total' ),
				'input_attrs' => array(
					'placeholder' => '0',
				),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten' ), // already have gutters.
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'logo_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
			),
			'control_display' => array(
				'check' => 'custom_logo',
				'value' => 'false',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-site-logo-color',
			),
		),
		array(
			'id' => 'logo_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
			),
			'control_display' => array(
				'check' => 'custom_logo',
				'value' => 'false',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-site-logo-color',
			),
		),
		array(
			'id' => 'logo_hover_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Hover Color', 'total' ),
			),
			'control_display' => array(
				'check' => 'custom_logo',
				'value' => 'false',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-hover-site-logo-color',
			),
		),
		array(
			'id' => 'custom_logo',
			'control' => array(
				'label' => esc_html__( 'Image Logo', 'total' ),
				'type' => 'media',
				'mime_type' => 'image'
			),
		),
		array(
			'id' => 'logo_img_max_height',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Max Height Ratio', 'total' ),
				'type' => 'number',
				'description' => esc_html__( 'Applies a max-height to the logo as a percentage of the header height to prevent overflow and create vertical padding.', 'total' ),
				'input_attrs' => array(
					'placeholder' => '0.6',
					'min' => '0.1',
					'step' => '0.1',
					'max' => '1',
				),
				'active_callback' => 'wpex_cac_supports_logo_max_height_ratio',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-site-logo-max-height-ratio',
				'sanitize' => 'decimal',
			),
		),
		array(
			'id' => 'logo_height',
			'control' => array(
				'label' => esc_html__( 'Height', 'total' ) . ' ' . esc_html__( '(required for SVG\'s)', 'total' ),
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'description' => esc_html__( 'Used for image height attribute tag. If left empty, the theme will calculate the height automatically.', 'total' ),
			),
			'control_display' => array(
				'check' => 'custom_logo',
				'value' => 'not_empty',
			),
		),
		array(
			'id' => 'apply_logo_height',
			'control' => array(
				'label' => esc_html__( 'Apply Height', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Enable to apply your logo height to the image. Useful for displaying large logos at a smaller size. Note: If you have enabled the shrink sticky header style you need to alter your height value under the Sticky Header settings.', 'total' ),
			),
			'control_display' => array(
				'check' => 'custom_logo',
				'value' => 'not_empty',
			),
		),
		array(
			'id' => 'logo_width',
			'control' => array(
				'label' => esc_html__( 'Width', 'total' ) . ' ' . esc_html__( '(optional)', 'total' ),
				'description' => esc_html__( 'Used for image width attribute tag.', 'total' ),
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
			),
			'control_display' => array(
				'check' => 'custom_logo',
				'value' => 'not_empty',
			),
		),
		array(
			'id' => 'retina_logo',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Retina Image Logo', 'total' ),
				'type' => 'media',
				'mime_type' => 'image',
			),
			'control_display' => array(
				'check' => 'custom_logo',
				'value' => 'not_empty',
			),
		),
		array(
			'id' => 'logo_max_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Logo Max Width: Desktop', 'total' ),
				'type' => 'wpex_length_unit',
				'description' => esc_html__( 'Screens 960px wide and greater.', 'total' ),
			),
			'control_display' => array(
				'check' => 'custom_logo',
				'value' => 'not_empty',
			),
			'inline_css' => array(
				'media_query' => '(min-width: 960px)',
				'target' => '#site-logo .logo-img',
				'alter' => 'max-width',
			),
		),
		array(
			'id' => 'logo_max_width_tablet_portrait',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Logo Max Width: Tablet Portrait', 'total' ),
				'type' => 'wpex_length_unit',
				'description' => esc_html__( 'Screens 768px-959px wide.', 'total' ),
			),
			'control_display' => array(
				'check' => 'custom_logo',
				'value' => 'not_empty',
			),
			'inline_css' => array(
				'media_query' => '(min-width: 768px) and (max-width: 959px)',
				'target' => '#site-logo .logo-img',
				'alter' => 'max-width',
			),
		),
		array(
			'id' => 'logo_max_width_phone',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Logo Max Width: Phone', 'total' ),
				'type' => 'wpex_length_unit',
				'description' => esc_html__( 'Screens smaller than 767px wide.', 'total' ),
			),
			'control_display' => array(
				'check' => 'custom_logo',
				'value' => 'not_empty',
			),
			'inline_css' => array(
				'media_query' => '(max-width: 767px)',
				'target' => '#site-logo .logo-img',
				'alter' => 'max-width',
			),
		),
	)
);