<?php
namespace TotalTheme\Filters;

use TotalTheme\Header\Core as Header;
use TotalTheme\Topbar\Core as Topbar;
use TotalTheme\Header\Vertical as Vertical_Header;
use TotalTheme\Header\Overlay as Overlay_Header;
use TotalTheme\Mobile\Menu as Mobile_Menu;

defined( 'ABSPATH' ) || exit;

/**
 * Hooks into "body_class".
 *
 * @package TotalTheme
 * @subpackage Filters
 * @version 5.4.3
 */
final class Body_Class {

	/**
	 * Callback method.
	 */
	public static function callback( $classes ) {
		$extra_classes = self::get_theme_classes();

		if ( $extra_classes ) {
			$classes = array_merge( $classes, $extra_classes );
		}

		return $classes;
	}

	/**
	 * Returns theme classes to add to the body class.
	 */
	protected static function get_theme_classes() {
		$classes     = array();
		$post_id     = wpex_get_current_post_id();
		$main_layout = wpex_site_layout( $post_id );

		// Customizer.
		if ( is_customize_preview() ) {
			$classes[] = 'is_customize_preview'; // @todo remove?
		}

		// Main class.
		$classes[] = 'wpex-theme';

		// Responsive.
		if ( wpex_is_layout_responsive() ) {
			$classes[] = 'wpex-responsive';
		}

		// Layout Style.
		$classes[] = sanitize_html_class( $main_layout ) . '-main-layout'; //@todo deprecate

		// Check if the WPbakery is being used on this page.
		// @todo can this be deprecated now?
		if ( wpex_has_post_wpbakery_content( $post_id ) ) {
			$classes[] = 'has-composer';
		} else {
			$classes[] = 'no-composer';
		}

		// Live site class.
		if ( ! wpex_vc_is_inline() ) {
			$classes[] = 'wpex-live-site'; // @todo remove this unneded check.
		}

		// Add primary element bottom margin.
		if ( wpex_has_primary_bottom_spacing() ) {
			$classes[] = 'wpex-has-primary-bottom-spacing';
		}

		// Boxed Layout dropshadow.
		if ( 'boxed' === $main_layout && get_theme_mod( 'boxed_dropdshadow' ) ) {
			$classes[] = 'wrap-boxshadow';
		}

		// Main & Content layouts.
		$classes[] = 'site-' . sanitize_html_class( $main_layout ); // @added in 5.1.3
		$classes[] = 'content-' . sanitize_html_class( wpex_content_area_layout( $post_id ) );

		// Sidebar.
		if ( wpex_has_sidebar() ) {
			$classes[] = 'has-sidebar';
		}

		// Extra header classes.
		if ( Header::is_enabled() ) {
			if ( Vertical_Header::is_enabled() ) {
				$classes[] = 'wpex-has-vertical-header';
				$classes[] = 'wpex-vertical-header-' . sanitize_html_class( Vertical_Header::position() );
				if ( 'fixed' === Vertical_Header::style() ) {
					$classes[] = 'wpex-fixed-vertical-header';
				}
			}
		} else {
			$classes[] = 'wpex-site-header-disabled';
		}

		// Topbar.
		if ( Topbar::is_enabled() ) {
			$classes[] = 'has-topbar';
		}

		// Single Post cagegories
		if ( is_singular( 'post' ) ) {
			$cats = get_the_category( $post_id );
			foreach ( $cats as $cat ) {
				$classes[] = 'post-in-category-' . sanitize_html_class( $cat->category_nicename );
			}
		}

		// Widget Icons.
		if ( get_theme_mod( 'has_widget_icons', true ) ) {
			$classes[] = 'sidebar-widget-icons';
		}

		// Overlay header style.
		if ( Overlay_Header::is_enabled() ) {
			$classes[] = 'has-overlay-header';
		} else {
			$classes[] = 'hasnt-overlay-header';
		}

		// Footer reveal.
		if ( wpex_has_footer_reveal() ) {
			$classes[] = 'footer-has-reveal';
		}

		// Fixed Footer - adds min-height to main wraper.
		if ( get_theme_mod( 'fixed_footer', false ) ) {
			$classes[] = 'wpex-has-fixed-footer';
		}

		// Disabled header.
		if ( wpex_has_page_header() ) {
			if ( 'background-image' === wpex_page_header_style() ) {
				$classes[] = 'page-with-background-title';
			}
		} else {
			$classes[] = 'page-header-disabled';
		}

		// Disable title margin.
		// @todo deprecate this class? Maybe we shouldn't because it could be used to add CSS as needed for spacing, etc.
		if ( $post_id && wpex_validate_boolean( get_post_meta( $post_id, 'wpex_disable_header_margin', true ) ) ) {
			$classes[] = 'no-header-margin';
		}

		// Page slider.
		if ( wpex_has_post_slider( $post_id ) && $slider_position = wpex_post_slider_position( $post_id ) ) {
			$classes[] = 'page-with-slider'; // Deprecated @todo remove this class.
			$classes[] = 'has-post-slider';
			$classes[] = 'post-slider-' . sanitize_html_class( str_replace( '_', '-', $slider_position ) );
		}

		// Font smoothing.
		if ( get_theme_mod( 'enable_font_smoothing', false ) ) {
			$classes[] = 'wpex-antialiased';
		}

		// Mobile menu toggle style.
		if ( Mobile_Menu::is_enabled() ) {

			// Mobile menu toggle style.
			$classes[] = 'wpex-mobile-toggle-menu-' . sanitize_html_class( wpex_header_menu_mobile_toggle_style() );

			// Mobile menu style.
			$classes[] = 'has-mobile-menu';

		} elseif ( wpex_has_header_menu() ) {
			if ( ! wpex_has_flex_header() ) {
				$classes[] = 'hasnt-mobile-menu'; // these classes cause issues with new flex styles.
			}
		}

		// Navbar inner span bg.
		if ( get_theme_mod( 'menu_link_span_background' ) ) {
			$classes[] = 'navbar-has-inner-span-bg';
		}

		// Togglebar.
		if ( 'inline' === wpex_togglebar_style() ) {
			$classes[] = 'togglebar-is-inline';
		}

		// Frame border.
		if ( wpex_has_site_frame_border() ) {
			$classes[] = 'has-frame-border';
		}

		// Pagination gutter.
		$pag_gutter = get_theme_mod( 'pagination_gutter', null );
		if ( $pag_gutter && '0' !== $pag_gutter && '-1' !== $pag_gutter ) {
			$classes[] = 'has-pagination-gutter';
		}

		// Social share position.
		if ( wpex_has_social_share() ) {
			$position = wpex_social_share_position();
			if ( $position ) {
				$classes[] = 'wpex-share-p-' . sanitize_html_class( $position );
			}
		}

		// Post author comment highlight/
		if ( get_theme_mod( 'bypostauthor_highlight' ) ) {
			$classes[] = 'comment-author-highlight';
		}

		// WooCommerce.
		if ( WPEX_WOOCOMMERCE_ACTIVE ) {
			if ( get_theme_mod( 'woo_product_responsive_tabs', false ) && is_singular( 'product' ) ) {
				$classes[] = 'woo-single-responsive-tabs';
			}
			if ( get_theme_mod( 'woo_checkout_single_col', false ) ) {
				$classes[] = 'wpex-fw-checkout';
			}
		}

		// No JS class.
		$classes[] = 'wpex-no-js';

		return $classes;
	}

}