<?php
namespace TotalTheme;

defined( 'ABSPATH' ) || exit;

/**
 * Custom site backgrounds.
 *
 * @package TotalTheme
 * @version 5.4.5
 */
class Site_Backgrounds {

	/**
	 * Class instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the class instance.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}
		return static::$instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_filter( 'wpex_head_css', __CLASS__ . '::update_head_css', 999 );
	}

	/**
	 * Hooks into wpex_head_css to add custom css to the <head> tag.
	 */
	public static function update_head_css( $head_css ) {
		$css      = '';
		$image    = get_theme_mod( 't_background_image' ); // converted from background_img in 4.3 to prevent conflict with WP
		$style    = get_theme_mod( 't_background_style' );
		$position = get_theme_mod( 't_background_position' );
		$pattern  = get_theme_mod( 't_background_pattern' );
		$post_id  = wpex_get_current_post_id();

		// Check Theme Settings post metabox.
		if ( $post_id ) {

			// Color.
			$single_color = get_post_meta( $post_id, 'wpex_page_background_color', true );

			// Image.
			$single_image = get_post_meta( $post_id, 'wpex_page_background_image_redux', true );
			if ( $single_image ) {
				if ( is_array( $single_image ) ) {
					$single_image = ( ! empty( $single_image['url'] ) ) ? $single_image['url'] : '';
				} else {
					$single_image = $single_image;
				}
			} else {
				$single_image = get_post_meta( $post_id, 'wpex_page_background_image', true );
			}

			// Background style.
			$single_style = get_post_meta( $post_id, 'wpex_page_background_image_style', true );

		}

		// Sanitize meta data.
		$color = ! empty( $single_color ) ? $single_color : '';
		$style = ( ! empty( $single_image ) && ! empty( $single_style ) ) ? $single_style : $style;
		$image = ! empty( $single_image ) ? $single_image : $image;

		// Create array of background settings.
		$settings = array(
			'color'    => $color,
			'image'    => $image,
			'style'    => $style,
			'pattern'  => $pattern,
			'position' => $position,
		);

		/**
		 * Filters the site background settings.
		 *
		 * @param array $settings
		 */
		$settings = (array) apply_filters( 'wpex_body_background_settings', $settings );

		if ( ! $settings ) {
			return;
		}

		extract( $settings );

		if ( $image && is_numeric( $image ) ) {
			$image = wp_get_attachment_image_src( $image, 'full' );
			$image = $image[0] ?? '';
		}

		$style = ! empty( $style ) ? $style : 'stretched';

		/*-----------------------------------------------------------------------------------*/
		/*  - Generate CSS
		/*-----------------------------------------------------------------------------------*/

		// Color.
		if ( ! empty( $color ) && '#' !== $color ) {
			$color_escaped = wp_strip_all_tags( $color );
			$css .= 'background-color:' . $color_escaped . '!important;';
			if ( wpex_has_footer_reveal() ) {
				$head_css .= '.footer-has-reveal #main{ background-color:' . $color_escaped . '!important;}';
			}
		}

		// Image.
		if ( ! empty( $image ) && empty( $pattern ) ) {
			$css .= 'background-image:url(' . esc_url( $image ) . ') !important;';
			$css .= wpex_sanitize_data( $style, 'background_style_css' );
			if ( ! empty( $position ) ) {
				$css .= 'background-position:' . esc_attr( $position ) . ';';
			}
		}

		// Pattern.
		if ( ! empty( $pattern ) ) {
			$patterns = wpex_get_background_patterns();
			if ( ! empty( $patterns[$pattern]['url'] ) ) {
				$css .= 'background-image:url(' . esc_url( $patterns[$pattern]['url'] ) . '); background-repeat:repeat;';
			}
		}

		/*-----------------------------------------------------------------------------------*/
		/*  - Return $css
		/*-----------------------------------------------------------------------------------*/
		if ( ! empty( $css ) ) {
			$css = '/*SITE BACKGROUND*/body{' . $css . '}';
			$head_css .= $css;
		}

		return $head_css;
	}

}