<?php
/**
 * Helper functions for the theme builder features.
 *
 * @package TotalTheme
 * @version 5.4.5
 */

defined( 'ABSPATH' ) || exit;

/*-------------------------------------------------------------------------------*/
/* [ Table of contents ]
/*-------------------------------------------------------------------------------*

	# Core
	# Header
	# Footer
	# Single (Dynamic Templates)

/*-------------------------------------------------------------------------------*/
/* [ Core ]
/*-------------------------------------------------------------------------------*/
function wpex_theme_do_location( $location = '' ) {
	$theme_builder = TotalTheme\Theme_Builder::instance();
	return $theme_builder->do_location( $location );
}

/*-------------------------------------------------------------------------------*/
/* [ Header ]
/*-------------------------------------------------------------------------------*/

/**
 * Get header builder ID
 */
function wpex_header_builder_id() {
	if ( class_exists( 'TotalTheme\\HeaderBuilder' ) ) {
		return TotalTheme\HeaderBuilder::get_template_id();
	}
}

/**
 * Check if we are currently in header builder edit mode.
 */
function wpex_is_header_builder_page() {
	if ( ! empty( $_GET[ 'wpex_inline_header_template_editor' ] ) ) {
		return true;
	}
	$header_builder_id = wpex_header_builder_id();
	if ( $header_builder_id && $header_builder_id == wpex_get_current_post_id() ) {
		return true;
	}
}

/*-------------------------------------------------------------------------------*/
/* [ Footer ]
/*-------------------------------------------------------------------------------*/

/**
 * Get footer builder ID.
 */
function wpex_footer_builder_id() {
	if ( class_exists( 'TotalTheme\\FooterBuilder' ) ) {
		return TotalTheme\FooterBuilder::get_template_id();
	}
}

/**
 * Check if we are currently in footer builder edit mode.
 */
function wpex_is_footer_builder_page() {
	if ( ! empty( $_GET[ 'wpex_inline_footer_template_editor' ] ) ) {
		return true;
	}
	$footer_builder_id = wpex_footer_builder_id();
	if ( $footer_builder_id && $footer_builder_id == wpex_get_current_post_id() ) {
		return true;
	}
}

/*-------------------------------------------------------------------------------*/
/* [ Single ]
/*-------------------------------------------------------------------------------*/

// @todo update to to use new Post_Template class and soft deprecate these functions
// @todo make the "wpex_get_singular_template_content" function return nothing and update the theme
// so that we make use of the TotalTheme\Theme_Builder\Location_Template instead - this way the Post_Template is part of
// the Theme_Builder class and we can update all the partial files to not have to do the extra checks.

/**
 * Check if a given post has a singular template.
 */
function wpex_has_singular_template() {
	return TotalTheme\Theme_Builder\Post_Template::has_template();
}

/**
 * Returns post template.
 */
function wpex_get_singular_template_id( $post_type = '' ) {
	return TotalTheme\Theme_Builder\Post_Template::get_template_id( $post_type );
}

/**
 * Returns post template content.
 */
function wpex_get_singular_template_content( $post_type = '' ) {
	return TotalTheme\Theme_Builder\Post_Template::get_template_content( $post_type );
}

/**
 * Returns the single post template.
 */
function wpex_singular_template( $template_content = '' ) {
	echo TotalTheme\Theme_Builder\Post_Template::render_template( $template_content );
}

/**
 * Returns post ID when using a dynamic template.
 */
function wpex_get_dynamic_post_id() {
	$post_id = wpex_get_current_post_id();

	/**
	 * Filters the post ID when using dynamic templates.
	 *
	 * @param int $post_id
	 */
	$post_id = apply_filters( 'wpex_get_dynamic_post_id', $post_id );

	return $post_id;
}