<?php
/**
 * Cart overlay.
 *
 * @package Total WordPress theme
 * @subpackage Partials
 * @version 5.4.3
 */

defined( 'ABSPATH' ) || exit;

if ( ! wp_script_is( 'wpex-wc-cart-overlay', 'enqueued' ) ) {
	wp_enqueue_script( 'wpex-wc-cart-overlay' );
}

?>

<div id="wpex-cart-overlay" class="wpex-fs-overlay">
	<button class="wpex-close">
		<span class="wpex-close__icon" aria-hidden="true">&times;</span>
		<span class="screen-reader-text"><?php esc_html_e( 'Close cart', 'total' ); ?></span>
	</button>
	<div class="wpex-inner wpex-scale wpex-bg-white wpex-py-10 wpex-px-20">
		<?php the_widget(
			'WC_Widget_Cart',
			array(),
			array(
				'before_title' => '<span class="widgettitle screen-reader-text">',
				'after_title' => '</span>'
			)
		); ?>
	</div>
</div>