<?php
use TotalTheme\Header\Overlay as Overlay_Header;
use TotalTheme\Mobile\Menu as Mobile_Menu;

/**
 * Toggle (dropdown) mobile menu element that gets populated via JS.
 *
 * @package TotalTheme
 * @subpackage Partials
 * @version 5.4
 *
 * @todo create TotalTheme\Mobile\Menu\Toggle class to slim down this file.
 */

defined( 'ABSPATH' ) || exit;

$mm_toggle_style = wpex_header_menu_mobile_toggle_style();

// Get position.
$position = 'afterheader';
if ( get_theme_mod( 'fixed_header_mobile' ) ) {
	$position = 'absolute'; // always absolute if sticky on mobile.
} else {
	switch ( $mm_toggle_style ) {
		case 'fixed_top':
			$position = 'absolute';
			break;
		case 'navbar':
			if ( 'outer_wrap_before' === get_theme_mod( 'mobile_menu_navbar_position', 'wpex_hook_header_bottom' )
				|| Overlay_Header::is_enabled()
			) {
				$position = 'afterself';
			}
			break;
		default:
			if ( Overlay_Header::is_enabled()
				|| ( wpex_has_sticky_header() && Mobile_Menu::breakpoint() >= 9999 )
			) {
				$position = 'absolute';
			}
			break;
	}
}

// Define append_to or insert_after vars (used for positioning the menu via JS).
if ( 'fixed_top' === $mm_toggle_style ) {
	$append_to = '#wpex-mobile-menu-fixed-top';
} elseif ( 'absolute' === $position ) {
	if ( 'navbar' === $mm_toggle_style ) {
		$append_to = '#wpex-mobile-menu-navbar';
	} else {
		$append_to = '#site-header';
	}
} elseif ( 'afterself' === $position ) {
	$insert_after = '#wpex-mobile-menu-navbar';
} else {
	$insert_after = '#site-header';
}

// Add classes.
$class = array(
	'mobile-toggle-nav',
	'wpex-mobile-menu',
);

if ( get_theme_mod( 'mobile_menu_toggle_animate', true ) ) {
	$class[] = 'mobile-toggle-nav--animate';
}

switch( $mm_toggle_style ) {
	case 'fixed_top':
		$class[] = 'wpex-surface-dark';
		break;
	default:
		$class[] = 'wpex-surface-1';
		break;
}

$class[] = 'wpex-togglep-' . sanitize_html_class ( $position );

// Utility classes
$class[] = 'wpex-z-9999';

switch( $position ) {
	case 'absolute':
		$class[] = 'wpex-absolute';
		$class[] = 'wpex-top-100';
		$class[] = 'wpex-left-0';
		$class[] = 'wpex-w-100';
		$class[] = 'wpex-overflow-y-auto';
		break;
}

// Define nav attributes.
$nav_attributes = array(
	'class'         => $class,
	'aria-expanded' => 'false',
	'aria-label'    => esc_attr( wpex_get_aria_label( 'mobile_menu' ) ),
);

if ( isset( $append_to ) ) {
	$nav_attributes['data-wpex-append-to'] = $append_to;
}

if ( isset( $insert_after ) ) {
	$nav_attributes['data-wpex-insert-after'] = $insert_after;
}

?>

<nav <?php echo wpex_parse_attrs( $nav_attributes ); ?>>
	<div class="mobile-toggle-nav-inner container">
		<?php
		/**
		 * Hook: wpex_hook_mobile_menu_top.
		 */
		Mobile_Menu::hook_top(); ?>
		<ul class="mobile-toggle-nav-ul wpex-h-auto wpex-leading-inherit wpex-list-none wpex-my-0 wpex-mx-auto"></ul>
		<?php
		/**
		 * Displays the mobile menu search form if enabled.
		 */
		ob_start();
			Mobile_Menu::search_form( array(
				'class' => 'wpex-relative wpex-pb-20',
			) );
		$search_form = ob_get_clean();
		if ( $search_form ) {
			echo '<div class="mobile-toggle-nav-search">' . $search_form . '</div>';
		} ?>
		<?php
		/**
		 * Hook: wpex_hook_mobile_menu_bottom.
		 */
		Mobile_Menu::hook_bottom(); ?>
	</div>
</nav>