<?php
/**
 * Mobile menu searchform.
 *
 * @package TotalTheme
 * @subpackage Partials
 * @version 5.4
 */

defined( 'ABSPATH' ) || exit;

$placeholder = $args['placeholder'] ?? esc_html__( 'Search', 'total' );
$action      = $args['action'] ?? esc_url( home_url( '/' ) );

/**
 * Filters the mobile menu searchform placeholder text.
 *
 * @param string $text
 */
$placeholder = (string) apply_filters( 'wpex_mobile_searchform_placeholder', $placeholder );

/**
 * Filters the mobile menu searchform action attribute.
 *
 * @param string $action
 * @param todo add new wpex_mobile_searchform_action_attribute filter.
 */
$action = (string) apply_filters( 'wpex_search_action', $action, 'mobile' );

$wrap_attributes = array(
	'id'    => $args['id'] ?? 'mobile-menu-search',
	'class' => $args['class'] ?? 'wpex-hidden',
);

?>

<div <?php echo wpex_parse_attrs( $wrap_attributes ); ?>>
	<form method="get" action="<?php echo esc_attr( $action ); ?>" class="mobile-menu-searchform">
		<label class="wpex-inherit-color">
			<span class="screen-reader-text"><?php echo esc_html( $placeholder ); ?></span>
			<input type="search" name="s" autocomplete="off" placeholder="<?php echo esc_attr( $placeholder ); ?>">
			<?php if ( defined( 'ICL_LANGUAGE_CODE' ) ) { ?>
				<input type="hidden" name="lang" value="<?php echo( ICL_LANGUAGE_CODE ); ?>">
			<?php } ?>
			<?php if ( WPEX_WOOCOMMERCE_ACTIVE && get_theme_mod( 'woo_header_product_searchform', false ) ) { ?>
				<input type="hidden" name="post_type" value="product">
			<?php } ?>
		</label>
		<button type="submit" class="searchform-submit"><?php wpex_theme_icon_html( 'search' ); ?><span class="screen-reader-text"><?php esc_html_e( 'Submit', 'total' ); ?></span></button>
	</form>
</div>